using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SFNET_Example_VS2005___CSharp
{
    public partial class Form1 : Form
    {
        //
        // Internal Variables
        //
        private double distanceMultiplier;
        private int startTruck;
        //
        public Form1()
        {
            InitializeComponent();
            //
            // Initialize our variables and components
            //
            trackbarLevel.Value = 0;
            trackbarTruck.Value = 0;
            sfnetCutaway.Level = (double)trackbarLevel.Value;
            sfnetBlower.AnalogIntValue1 = (short)trackbarLevel.Value;
            textboxLevelMax.Text = trackbarLevel.Maximum.ToString();
            textboxLevelMin.Text = trackbarLevel.Minimum.ToString();
            textboxLevelInt.Text = trackbarLevel.Value.ToString();
            sfnetValve.BandsCollection[0].DiscreteValue = true;
            sfnetValve.BandsCollection[1].DiscreteValue = false;
            //
            // Compute distance for the truck to travel
            //
            int truckDistance = this.Size.Width - sfnetTruck.Width - sfnetTruck.Left;
            distanceMultiplier = truckDistance / (trackbarTruck.Maximum - trackbarTruck.Minimum);
            trackbarTruck.Value = 0;
            startTruck = sfnetTruck.Left;
            sfnetTruck.Left = (int)(startTruck + (int)(trackbarTruck.Value * distanceMultiplier));
        }

        
        /// <summary>
        /// Handler for moving the Truck
        /// </summary>
        private void trackbarTruck_Scroll(object sender, EventArgs e)
        {
            sfnetTruck.Left = (int)(startTruck + (int)(trackbarTruck.Value * distanceMultiplier));
        }


        /// <summary>
        /// Handler for animating the Blower and Cutaway control
        /// </summary>
        private void trackbarLevel_Scroll(object sender, EventArgs e)
        {
            sfnetBlower.AnalogIntValue1 = (short)trackbarLevel.Value;
            sfnetCutaway.Level = (double)trackbarLevel.Value;
            textboxLevelInt.Text = trackbarLevel.Value.ToString();
        }


        /// <summary>
        /// Handler for turning ON the valve
        /// </summary>
        private void radiobuttonValveOn_CheckedChanged(object sender, EventArgs e)
        {
            sfnetValve.BandsCollection[0].DiscreteValue = true;
            sfnetValve.BandsCollection[1].DiscreteValue = false;
        }


        /// <summary>
        /// Handler for turning OFF the valve
        /// </summary>
        private void radiobuttonValveOff_CheckedChanged(object sender, EventArgs e)
        {
            sfnetValve.BandsCollection[0].DiscreteValue = false;
            sfnetValve.BandsCollection[1].DiscreteValue = true;
        }


        /// <summary>
        /// Handler for exiting the application
        /// </summary>
        private void buttonExit_Click(object sender, EventArgs e)
        {
            Application.Exit();

        }
    }
}